package at.jku.isse.gradient

import org.aeonbits.owner.Config
import org.aeonbits.owner.Config.DefaultValue
import org.aeonbits.owner.Config.Key

@Config.LoadPolicy(Config.LoadType.MERGE)
@Config.Sources(value = ["file:.gradient/gradient.config", "classpath:gradient.properties"])
interface GradientConfig : Config {

    @Key("gradient.client.observationCache")
    @DefaultValue("10000")
    fun observationCacheSize(): Int

    @Key("gradient.client.unwindDepth")
    @DefaultValue("500")
    fun iterableUnwindDepth(): Int

    @Key("gradient.server.connectionString")
    @DefaultValue("localhost:50051")
    fun gradientServerConnectionString(): String

    @Config.Key("mongo.connectionString")
    @Config.DefaultValue("mongodb://localhost:27017/")
    fun mongoConnectionString(): String

    @Config.Key("retryLogic.timeout")
    @Config.DefaultValue("100")
    fun retryLogicTimeout(): Int

    @Config.Key("retryLogic.retries")
    @Config.DefaultValue("1")
    fun retryLogicRetries(): Int
}