package at.jku.isse.gradient.service

import at.jku.isse.gradient.dal.ObservationDao
import at.jku.isse.psma.gradient.server.BehavioralServiceGrpc
import com.google.inject.AbstractModule
import com.google.inject.Provides

class ServiceModule : AbstractModule() {
    override fun configure() {
        bind(StructuralService::class.java)
    }

    @Provides
    fun behavioralServiceProvider(dao: ObservationDao,
                                  behavioralServiceStub: BehavioralServiceGrpc.BehavioralServiceBlockingStub): BehavioralService {
        return BehavioralService(dao, behavioralServiceStub)
    }
}