package at.jku.isse.gradient.service

import at.jku.isse.gradient.Util
import at.jku.isse.gradient.dal.ObservationDao
import at.jku.isse.psma.gradient.server.BehavioralServiceGrpc
import at.jku.isse.psma.gradient.server.ObservationReport
import com.google.inject.Inject
import mu.KotlinLogging
import java.time.Instant
import java.util.*

private val logger = KotlinLogging.logger {}

open class BehavioralService
@Inject internal constructor(private val observationDao: ObservationDao,
                             private val behavioralServiceStub: BehavioralServiceGrpc.BehavioralServiceBlockingStub) {

    fun report(projectName: String, versionId: UUID, runtimeId: UUID, observationBatch: List<Map<String, Any>>) {
        require(projectName.isNotBlank())

        if (observationBatch.isEmpty()) {
            logger.debug { "Observation batch was empty, skipping the report." }
            return
        }

        observationDao.reportObservations(projectName, versionId, runtimeId, observationBatch)
    }

    fun reportObservationEnd(projectName: String, versionId: UUID, runtimeId: UUID) {
        require(projectName.isNotBlank())
        logger.debug { "Reporting monitoring end to the gradient-server: $projectName" }

        val report = ObservationReport.newBuilder()
                .setId(Util.uuid().toString())
                .setProjectName(projectName)
                .setCollectionId(runtimeId.toString())
                .setVersionId(versionId.toString())
                .setTimestamp(Instant.now().epochSecond)
                .build()

        behavioralServiceStub.report(report)
    }
}