package at.jku.isse.gradient.monitoring

import com.google.common.io.Resources
import mu.KotlinLogging
import java.io.ByteArrayInputStream
import java.util.*

private val logger = KotlinLogging.logger {}

class StructuralCache {

    var projectName: String? = null
        private set
    var versionId: UUID? = null
        private set

    init {
        try {
            val url = Resources.getResource("structural.properties")

            val props = Properties().also { props ->
                ByteArrayInputStream(Resources.toByteArray(url)).use {
                    props.load(it)
                }
            }

            projectName = props.getProperty("project.name")

            val versionIdString = props.getProperty("project.version")
            versionId = versionIdString?.let { UUID.fromString(it) }

            logger.debug { "Finished loading structural cache: $projectName@$versionId" }
        } catch (ex: IllegalArgumentException) {
            logger.error { "Could not load structural.properties file" }
        }
    }

    fun present(): Boolean {
        return projectName != null && versionId != null
    }
}