package at.jku.isse.gradient.model

import java.util.*

class TypeParameterMapping : CanonicalEntity {
    companion object {
        fun canonicalNameOf(parameter: Type,
                            actualType: Type): String {
            return "${parameter.canonicalName} = ${actualType.canonicalName}"
        }
    }


    lateinit var parameter: Type
    lateinit var actualType: Type


    constructor()
    constructor(id: UUID,
                canonicalName: String,
                parameter: Type,
                actualType: Type) : super(id, canonicalName, canonicalName) {
        this.parameter = parameter
        this.actualType = actualType
    }

    override fun toString(): String {
        return "TypeParameterMapping(id='$canonicalName')"
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitTypeParameterMapping(this)
}