package at.jku.isse.gradient.model

import com.google.common.hash.HashCode
import java.util.*

class Property : TypedElement, Versionable {

    var visibility: Visibility = Visibility.PUBLIC
    var isStatic: Boolean = false
    var isImmutable: Boolean = false
    override var versionHash: HashCode = HashCode.fromInt(0)

    var shadows: MutableSet<Property> = mutableSetOf()

    constructor()
    constructor(id: UUID,
                name: String,
                canonicalName: String,
                visibility: Visibility,
                isStatic: Boolean,
                isImmutable: Boolean,
                gradientType: GradientType,
                versionHash: HashCode) : super(id, name, canonicalName, gradientType) {
        this.visibility = visibility
        this.isStatic = isStatic
        this.isImmutable = isImmutable
        this.versionHash = versionHash
        this.gradientType = gradientType
    }

    override fun toString(): String {
        return "Property(id='$canonicalName')"
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitProperty(this)
}