package at.jku.isse.gradient.model

import java.util.*

class Project : CanonicalEntity {

    lateinit var version: Version

    constructor()
    constructor(id: UUID,
                name: String,
                canonicalName: String,
                version: Version) : super(id, name, canonicalName) {
        this.version = version
    }

    override fun toString(): String {
        return "Project(id='$canonicalName')"
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitProject(this)
}