package at.jku.isse.gradient.model

import java.util.*

class Overriding(id: UUID,
                 canonicalName: String,
                 val source: Executable,
                 val target: Executable,
                 val overridingQuality: OverridingQuality) : CanonicalEntity(id, canonicalName, canonicalName) {

    companion object {
        fun canonicalNameOf(source: Executable,
                            target: Executable,
                            overridingQuality: OverridingQuality): String {
            return "${source.canonicalName} -[${overridingQuality.name}]-> ${target.canonicalName}"
        }
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitOverriding(this)
}