package at.jku.isse.gradient.model

import java.util.*

open class Invocation(id: UUID,
                      canonicalName: String,
                      val source: Executable,
                      val delegate: CanonicalEntity?,
                      val target: Executable,
                      val cardinality: Cardinality) : CanonicalEntity(id, canonicalName, canonicalName) {

    companion object {
        fun canonicalNameOf(source: Executable,
                            delegate: CanonicalEntity?,
                            target: Executable,
                            cardinality: Cardinality): String {
            val relationship = if (delegate != null) "=[${delegate.canonicalName}]=>" else "=>"
            return "${source.canonicalName} $relationship${cardinality.value} ${target.canonicalName}"
        }
    }

    override fun toString(): String {
        return "Invocation(source='${source.canonicalName}', target='${target.canonicalName}')"
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitInvocation(this)
}