package at.jku.isse.gradient.model

import java.util.*


class ElementType : CanonicalEntity {
    companion object {
        fun canonicalNameOf(baseType: Type,
                            cardinality: Cardinality,
                            typeParameterMappings: Iterable<TypeParameterMapping>): String {
            var typeParameterSignature = typeParameterMappings
                    .joinToString(" ") { it.canonicalName }
            if (typeParameterSignature.isNotBlank()) typeParameterSignature = " | $typeParameterSignature"

            return ">${baseType.canonicalName}${cardinality.value}$typeParameterSignature"
        }
    }


    lateinit var cardinality: Cardinality


    lateinit var typeOf: Type
    lateinit var typeParameterMappings: MutableList<TypeParameterMapping>


    constructor()
    constructor(id: UUID,
                canonicalName: String,
                baseType: Type,
                parameterTypeMappings: Iterable<TypeParameterMapping>,
                cardinality: Cardinality = Cardinality.ONE) : super(id, canonicalName, canonicalName) {
        this.typeOf = baseType
        this.typeParameterMappings = parameterTypeMappings.toMutableList()
        this.cardinality = cardinality
    }

    override fun toString(): String {
        return "ElementType(id='$canonicalName')"
    }

    override fun accept(visitor: ModelVisitor) = visitor.visitElementType(this)
}
