package at.jku.isse.gradient.lang.java

import at.jku.isse.gradient.model.*

data class ModelComponents(val components: MutableMap<String, Any> =
                           mutableMapOf(
                                   "types" to mutableMapOf<String, Type>(),
                                   "typeParametersMappings" to mutableMapOf<String, TypeParameterMapping>(),
                                   "properties" to mutableMapOf<String, Property>(),
                                   "executables" to mutableMapOf<String, Executable>(),
                                   "parameters" to mutableMapOf<String, Parameter>())) : Iterable<at.jku.isse.gradient.model.Entity> {
    override fun iterator(): Iterator<at.jku.isse.gradient.model.Entity> {
        val components = mutableListOf<at.jku.isse.gradient.model.Entity>()
        components.addAll(types.values)
        components.addAll(typeParametersMappings.values)
        components.addAll(properties.values)
        components.addAll(executables.values)
        components.addAll(parameters.values)
        return components.iterator()
    }

    companion object {
        fun mergeLeft(left: ModelComponents, right: ModelComponents): ModelComponents {
            left.types += right.types
            left.typeParametersMappings += right.typeParametersMappings
            left.properties += right.properties
            left.executables += right.executables
            left.parameters += right.parameters
            return left
        }
    }

    val types: MutableMap<String, Type> by components
    val typeParametersMappings: MutableMap<String, TypeParameterMapping> by components
    val properties: MutableMap<String, Property> by components
    val executables: MutableMap<String, Executable> by components
    val parameters: MutableMap<String, Parameter> by components

    override fun toString(): String {
        val total = types.size + properties.size + executables.size + parameters.size + typeParametersMappings.size
        return "ModelComponents[total=$total, types=${types.size}, properties=${properties.size}, executables=${executables.size}, parameters=${parameters.size}, typeParameters=${typeParametersMappings.size}]"
    }
}