package at.jku.isse.gradient.lang.java

import com.google.common.cache.CacheBuilder
import com.google.common.cache.CacheLoader
import com.google.common.reflect.ClassPath
import spoon.reflect.declaration.CtExecutable
import spoon.reflect.declaration.CtField
import spoon.reflect.declaration.CtParameter
import spoon.reflect.declaration.CtType
import spoon.reflect.factory.Factory
import spoon.reflect.reference.CtExecutableReference
import spoon.reflect.reference.CtFieldReference
import spoon.reflect.reference.CtParameterReference
import spoon.reflect.reference.CtTypeReference
import java.util.*
import java.util.concurrent.TimeUnit

class DeclarationCache {
    internal val type = CacheBuilder.newBuilder()
            .maximumSize(5000)
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .recordStats()
            .build(object : CacheLoader<CtTypeReference<*>, Optional<CtType<*>>>() {
                override fun load(key: CtTypeReference<*>): Optional<CtType<*>> {
                    return Optional.ofNullable(key.declaration ?: key.typeDeclaration)
                }
            })

    internal val property = CacheBuilder.newBuilder()
            .maximumSize(5000)
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .recordStats()
            .build(object : CacheLoader<CtFieldReference<*>, Optional<CtField<*>>>() {
                override fun load(key: CtFieldReference<*>): Optional<CtField<*>> {
                    return Optional.ofNullable(key.declaration ?: key.fieldDeclaration)
                }
            })
    internal val executable = CacheBuilder.newBuilder()
            .maximumSize(10000)
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .recordStats()
            .build(object : CacheLoader<CtExecutableReference<*>, Optional<CtExecutable<*>>>() {
                override fun load(key: CtExecutableReference<*>): Optional<CtExecutable<*>> {
                    return Optional.ofNullable(key.declaration ?: key.executableDeclaration)
                }
            })
    internal val parameter = CacheBuilder.newBuilder()
            .maximumSize(5000)
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .recordStats()
            .build(object : CacheLoader<CtParameterReference<*>, Optional<CtParameter<*>>>() {
                override fun load(key: CtParameterReference<*>): Optional<CtParameter<*>> {
                    return Optional.ofNullable(key.declaration)
                }
            })

    override fun toString(): String {
        return "Type\t\t${type.stats()}\n" +
                "Property\t${property.stats()}\n" +
                "Executable\t${executable.stats()}\n" +
                "Parameter\t${parameter.stats()}"
    }
}

