package at.jku.isse.gradient.dal.mongo

import at.jku.isse.gradient.dal.ServerManager
import at.jku.isse.gradient.dal.VersionDao
import com.google.inject.Inject
import com.mongodb.client.model.Filters
import com.mongodb.client.model.Updates
import mu.KotlinLogging
import java.util.*

private val logger = KotlinLogging.logger {}

class MongoVersionDao
@Inject constructor(private val serverManager: ServerManager) : VersionDao {

    override fun addDynamics(projectName: String, versionId: UUID, dynamicsId: UUID) {
        require(projectName.isNotBlank())

        serverManager.mongoDatabase(projectName)?.let { db ->
            if (PROJECT_COLLECTION in db.listCollectionNames()) {
                db.getCollection(PROJECT_COLLECTION).updateOne(
                        Filters.and(Filters.`in`("tags", "Version"), Filters.eq("id", versionId)),
                        Updates.push("dynamics", dynamicsId)
                )
            } else {
                logger.warn { "Could not find project collection; ignoring dynamics: $projectName@$versionId" }
            }
        }
    }
}