package at.jku.isse.gradient.dal.mongo

import at.jku.isse.gradient.dal.ServerManager
import at.jku.isse.gradient.dal.TypeDao
import com.google.inject.Inject
import com.mongodb.client.model.Filters
import com.mongodb.client.model.Updates
import mu.KotlinLogging
import java.util.*

private val logger = KotlinLogging.logger {}

class MongoTypeDao
@Inject constructor(private val serverManager: ServerManager) : TypeDao {

    override fun setIsGradientModel(projectName: String, versionId: UUID, typeName: String, isGradientModel: Boolean) {
        require(projectName.isNotBlank())
        require(typeName.isNotBlank())

        logger.debug { "Registering additional gradient model: $typeName" }

        serverManager.mongoDatabase(projectName)?.let { db ->
            val collectionName = toCollectionName(versionId.toString(), STRUCTURAL_COLLECTION_POSTFIX)
            if (collectionName in db.listCollectionNames()) {
                db.getCollection(collectionName).updateOne(
                        Filters.and(Filters.`in`("tags", "Type"),
                                Filters.eq("canonicalName", typeName)),
                        Updates.set("isGradientModel", isGradientModel)
                )
            } else {
                logger.warn { "Could not find the collection: $collectionName" }
            }
        }
    }
}