package at.jku.isse.gradient.dal.mongo

const val STRUCTURAL_COLLECTION_POSTFIX = "s"
const val EVENT_COLLECTION_POSTFIX = "e"
const val PROJECT_COLLECTION = "project"
const val ELEMENT_UNKNOWN = "<alien>"

fun toMongoDatabaseName(projectName: String): String {
    require(projectName.isNotBlank())

    var newName = projectName.replace(".", "-")
    if (newName.length > 50) {
        val components = newName.split("-")
        val prefix = components.dropLast(1)
                .map { it[0] }
                .joinToString("-")
        newName = "$prefix-${components.last()}"

        assert(newName.length < 50) { "Could not compact database name below mongo db restrictions." }
    }

    return newName
}

fun toCollectionName(collectionName: String, postfix: String): String {
    require(collectionName.isNotBlank())

    val newName = collectionName.replace("$", "-")
    return "${newName.take(5)}-${newName.takeLast(5)}-$postfix"
}
