package at.jku.isse.gradient

import at.jku.isse.gradient.dal.DalModule
import at.jku.isse.gradient.dal.ServerManager
import at.jku.isse.gradient.lang.java.AsgModule
import at.jku.isse.gradient.monitoring.MonitoringModule
import at.jku.isse.gradient.service.ServiceModule
import com.google.inject.Guice
import com.google.inject.Injector
import com.google.inject.Module
import java.util.*

class Gradient {
    private var injector: Injector? = null
    private var serverManager: ServerManager? = null

    private val modules: MutableSet<Module> = mutableSetOf(GradientModule(), ServiceModule(), DalModule(),
            MonitoringModule(), AsgModule())

    init {
        registerAdditionalModules(ServiceLoader.load(Module::class.java).toList())
    }

    fun registerAdditionalModules(modules: Iterable<Module>) {
        this.modules.addAll(modules)
        if (injector != null) {
            injector = injector!!.createChildInjector(modules)
        }
    }

    fun bootstrapGradient(): Injector {
        if (injector == null) {
            injector = Guice.createInjector(modules)
        }

        return injector!!
    }

    fun gradientBackendAvailable(): Boolean {
        if (serverManager == null) {
            val injector = bootstrapGradient()
            serverManager = injector.getInstance(ServerManager::class.java)
        }

        return if (serverManager != null) serverManager!!.backendAvailable() else false
    }
}
