package at.jku.isse.gradient.model

class Parameter : TypedElement {
    companion object {
        fun canonicalNameOf(executable: Executable, index: Int): String = "${executable.canonicalName}#$index"
    }


    constructor()
    constructor(id: String,
                name: String,
                canonicalName: String,
                gradientType: GradientType) : super(id, name, canonicalName, gradientType)

    override fun toString(): String = "Parameter(id='$canonicalName')"

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitParameter(this)
}