package at.jku.isse.gradient.model

open class Invocation(id: String,
                      canonicalName: String,
                      val source: Executable,
                      val delegate: at.jku.isse.gradient.model.CanonicalEntity?,
                      val target: Executable,
                      val cardinality: Cardinality) : at.jku.isse.gradient.model.CanonicalEntity(id, canonicalName, canonicalName) {

    companion object {
        fun canonicalNameOf(source: Executable,
                            delegate: at.jku.isse.gradient.model.CanonicalEntity?,
                            target: Executable,
                            cardinality: Cardinality): String {
            val relationship = if (delegate != null) "=[${delegate.canonicalName}]=>" else "=>"
            return "${source.canonicalName} $relationship${cardinality.value} ${target.canonicalName}"
        }
    }

    override fun toString(): String {
        return "Invocation(source='${source.canonicalName}', target='${target.canonicalName}')"
    }

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitInvocation(this)
}