package at.jku.isse.gradient.model

class Access(id: String,
             canonicalName: String,
             val source: Executable,
             val delegate: at.jku.isse.gradient.model.CanonicalEntity?,
             val target: Property,
             val cardinality: Cardinality,
             val accessType: AccessType) : at.jku.isse.gradient.model.CanonicalEntity(id, canonicalName, canonicalName) {

    companion object {
        fun canonicalNameOf(source: Executable,
                            delegate: at.jku.isse.gradient.model.CanonicalEntity?,
                            target: Property,
                            cardinality: Cardinality,
                            accessType: AccessType): String {
            val sourceDirection = if (accessType == AccessType.READ || accessType == AccessType.FULL) "<" else ""
            val targetDirection = if (accessType == AccessType.WRITE || accessType == AccessType.FULL) ">" else ""
            val relationship = if (delegate != null) "$sourceDirection-[${delegate.canonicalName}]-$targetDirection" else "$sourceDirection-$targetDirection"
            return "${source.canonicalName} $relationship${cardinality.value} ${target.canonicalName}"
        }
    }

    override fun toString(): String {
        return "Access(source='${source.canonicalName}', target='${target.canonicalName}')"
    }

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitAccess(this)
}

