package at.jku.isse.gradient.dal.mongo

import at.jku.isse.gradient.GradientConfig
import com.mongodb.ConnectionString
import com.mongodb.MongoClientSettings
import com.mongodb.client.MongoClients
import com.mongodb.client.model.Indexes
import mu.KotlinLogging
import org.aeonbits.owner.ConfigFactory
import java.util.concurrent.TimeUnit

private val logger = KotlinLogging.logger {}

internal object MongoConfiguration {
    fun configure(runtimeCollection: String) {
        logger.debug { "Creating indexes" }

        val config = ConfigFactory.create(GradientConfig::class.java)
        try {
            val settings = MongoClientSettings.builder()
                    .applyToServerSettings { it.applyConnectionString(ConnectionString(config.mongoConnectionString())) }
                    .applyToSocketSettings { it.connectTimeout(100, TimeUnit.MILLISECONDS) }
                    .applyToClusterSettings { it.serverSelectionTimeout(100, TimeUnit.MILLISECONDS) }
                    .build()

            val client = MongoClients.create(settings)
            val collection = client.getDatabase("dynamic-analysis")
                    .getCollection(runtimeCollection)
            collection.createIndex(Indexes.ascending("observeeName"))
            collection.createIndex(Indexes.ascending("type"))
            collection.createIndex(Indexes.ascending("executableContext"))
            collection.createIndex(Indexes.ascending("parentExecutableContext"))
            collection.createIndex(Indexes.ascending("values.elementName"))

        } catch (e: Exception) {
            logger.error(e) { "Could not configure MongoDb. Are the services reachable?" }
        }
    }
}