package at.jku.isse.gradient.dal.mongo

import at.jku.isse.gradient.dal.GradientServerManager
import at.jku.isse.gradient.dal.ObservationDao
import at.jku.isse.gradient.dal.QueryDao
import com.google.inject.Inject
import mu.KotlinLogging
import org.bson.Document

private val logger = KotlinLogging.logger {}

class BatchMongoObservationDao
@Inject constructor(private val gradientServerManager: GradientServerManager,
                    private val dao: QueryDao) : ObservationDao {

    override fun reportObservationBatch(projectName: String, versionId: String, runtimeId: String,
                                        observationBatch: List<Map<String, Any>>) {
        if (observationBatch.isEmpty())
            return

        gradientServerManager.mongoDatabase("dynamic-analysis", 10, 0)?.let {
            logger.debug { "Preparing documents: ${observationBatch.size} observations" }
            val documents = observationBatch.map { Document(it) }

            logger.debug { "Creating new session" }
            val collection = it.getCollection(runtimeId)

            logger.debug { "Writing data" }
            collection.insertMany(documents)
            reportToNeo4j(projectName, versionId, runtimeId)
        }
    }

    private fun reportToNeo4j(projectName: String, versionId: String, runtimeId: String) {
        val query = """
                    MATCH (:Project {canonicalName:{projectName}})
                            -[:contains]-> (v:Version {id:{versionId}})
                    MERGE (v) -[:observed]-> (:Dynamics {collectionId:{collectionId}})
                    """.trimIndent()

        dao.query(
                query,
                mapOf("projectName" to projectName,
                        "versionId" to versionId,
                        "collectionId" to runtimeId)
        )
    }
}