package at.jku.isse.gradient.model

class TypeParameterMapping : at.jku.isse.gradient.model.CanonicalEntity {
    companion object {
        fun canonicalNameOf(parameter: Type,
                            actualType: Type): String {
            return "${parameter.canonicalName} = ${actualType.canonicalName}"
        }
    }


    lateinit var parameter: Type
    lateinit var actualType: Type


    constructor()
    constructor(id: String,
                canonicalName: String,
                parameter: Type,
                actualType: Type) : super(id, canonicalName, canonicalName) {
        this.parameter = parameter
        this.actualType = actualType
    }

    override fun toString(): String {
        return "TypeParameterMapping(id='$canonicalName')"
    }

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitTypeParameterMapping(this)
}