package at.jku.isse.gradient.model

import com.google.common.hash.HashCode

class Type : at.jku.isse.gradient.model.CanonicalEntity, Versionable {
    lateinit var availability: Availability

    lateinit var quality: Quality
    lateinit var visibility: Visibility
    var isGenerics: Boolean = false
    var isGradientModel: Boolean = false
    override lateinit var versionHash: HashCode

    var typeParameters: MutableSet<Type> = mutableSetOf()
    var isExtending: MutableSet<Type> = mutableSetOf()
    var properties: MutableSet<Property> = mutableSetOf()
    var executables: MutableSet<Executable> = mutableSetOf()
    var inheritedProperties: MutableSet<Property> = mutableSetOf()
    var inheritedExecutables: MutableSet<Executable> = mutableSetOf()


    constructor()
    constructor(id: String,
                name: String,
                canonicalName: String,
                availability: Availability,
                quality: Quality,
                visibility: Visibility,
                isGenerics: Boolean,
                isGradientModel: Boolean,
                versionHash: HashCode) : super(id, name, canonicalName) {
        this.availability = availability
        this.quality = quality
        this.visibility = visibility
        this.isGenerics = isGenerics
        this.versionHash = versionHash
        this.isGradientModel = isGradientModel
    }

    override fun toString(): String {
        return "Type(id='$canonicalName')"
    }

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitType(this)
}