package at.jku.isse.gradient.model

import com.google.common.hash.HashCode

class Property : TypedElement, Versionable {

    lateinit var visibility: Visibility
    var isStatic: Boolean = false
    var isImmutable: Boolean = false
    override lateinit var versionHash: HashCode


    var shadows: MutableSet<Property> = mutableSetOf()


    constructor()
    constructor(id: String,
                name: String,
                canonicalName: String,
                visibility: Visibility,
                isStatic: Boolean,
                isImmutable: Boolean,
                gradientType: GradientType,
                versionHash: HashCode) : super(id, name, canonicalName, gradientType) {
        this.visibility = visibility
        this.isStatic = isStatic
        this.isImmutable = isImmutable
        this.versionHash = versionHash
        this.gradientType = gradientType
    }

    override fun toString(): String {
        return "Property(id='$canonicalName')"
    }

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitProperty(this)
}