package at.jku.isse.gradient.model

import com.google.common.hash.HashCode

class Executable : TypedElement, Versionable {

    var isAbstract: Boolean = false
    lateinit var visibility: Visibility
    var isStatic: Boolean = false
    var isConstructor: Boolean = false
    var accessor: Accessor = Accessor.NONE
    override lateinit var versionHash: HashCode

    var overrides: MutableSet<Overriding> = mutableSetOf()
    var parameters: MutableSet<Parameter> = mutableSetOf()
    var returns: MutableSet<ElementType> = mutableSetOf()
    var accesses: MutableSet<Access> = mutableSetOf()
    var invokes: MutableSet<Invocation> = mutableSetOf()
    var typeParameters: MutableSet<Type> = mutableSetOf()

    constructor()
    constructor(id: String,
                name: String,
                canonicalName: String,
                isAbstract: Boolean,
                visibility: Visibility,
                isStatic: Boolean,
                isConstructor: Boolean,
                gradientType: GradientType,
                versionHash: HashCode) : super(id, name, canonicalName, gradientType) {
        this.isAbstract = isAbstract
        this.visibility = visibility
        this.isStatic = isStatic
        this.isConstructor = isConstructor
        this.versionHash = versionHash
    }

    override fun toString(): String {
        return "Executable(id='$canonicalName')"
    }

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitExecutable(this)
}