package at.jku.isse.gradient

import at.jku.isse.gradient.dal.DalModule
import at.jku.isse.gradient.dal.GradientServerManager
import at.jku.isse.gradient.monitoring.MonitoringModule
import com.google.inject.Guice
import com.google.inject.Injector
import com.google.inject.Module
import java.util.*

class Gradient {
    private var injector: Injector? = null
    private var gradientServerManager: GradientServerManager? = null

    private val modules: MutableSet<Module> = mutableSetOf(GradientModule(), DalModule(), MonitoringModule())

    init {
        registerAdditionalModules(ServiceLoader.load(Module::class.java).toList())
    }

    fun registerAdditionalModules(modules: Iterable<Module>) {
        this.modules.addAll(modules)
        if (injector != null) {
            injector = injector!!.createChildInjector(modules)
        }
    }

    fun bootstrapGradient(): Injector {
        if (injector == null) {
            injector = Guice.createInjector(modules)
        }

        return injector!!
    }

    fun gradientBackendAvailable(): Boolean {
        if (gradientServerManager == null) {
            val injector = bootstrapGradient()
            gradientServerManager = injector.getInstance(GradientServerManager::class.java)
        }

        return if (gradientServerManager != null) gradientServerManager!!.backendAvailable() else false
    }
}
