package at.jku.isse.gradient.service

import at.jku.isse.gradient.dal.ObservationDao
import at.jku.isse.psma.gradient.server.BehavioralServiceGrpc
import at.jku.isse.psma.gradient.server.ObservationReport
import com.fasterxml.uuid.Generators
import com.google.inject.Inject
import mu.KotlinLogging
import java.time.Instant

private val logger = KotlinLogging.logger {}

open class BehavioralService
@Inject internal constructor(private val observationDao: ObservationDao,
                             private val behavioralServiceStub: BehavioralServiceGrpc.BehavioralServiceBlockingStub) {

    private val uuidGenerator = Generators.timeBasedGenerator()

    fun report(projectName: String, versionId: String, runtimeId: String, observationBatch: List<Map<String, Any>>) {
        require(projectName.isNotBlank())
        require(versionId.isNotBlank())
        require(runtimeId.isNotBlank())

        observationDao.reportObservationBatch(projectName, versionId, runtimeId, observationBatch)
    }

    fun reportObservationEnd(projectName: String, versionId: String, runtimeId: String) {
        require(projectName.isNotBlank())
        require(versionId.isNotBlank())
        require(runtimeId.isNotBlank())
        logger.debug { "Reporting monitoring end to the gradient-server: $projectName" }

        val report = ObservationReport.newBuilder()
                .setId(uuidGenerator.generate().toString())
                .setProjectName(projectName)
                .setCollectionId(runtimeId)
                .setVersionId(versionId)
                .setTimestamp(Instant.now().epochSecond)
                .build()

        behavioralServiceStub.report(report)
    }
}