package at.jku.isse.gradient.monitoring

import com.google.inject.Inject
import com.google.inject.name.Named
import mu.KotlinLogging
import java.io.File
import java.io.FileReader
import java.util.*

private val logger = KotlinLogging.logger {}

class StructuralCache
@Inject constructor(@Named("structural.properties") private val structuralCache: File) {

    init {
        reload()
    }

    lateinit var projectName: String
        private set

    lateinit var versionId: String
        private set

    fun reload() {
        val props = Properties()
        props.load(FileReader(structuralCache))
        projectName = props.getProperty("project.name") ?: ""
        versionId = props.getProperty("project.version") ?: ""
        logger.debug("Reinitialized the structural cache.")
    }
}