package at.jku.isse.gradient.model

class Project : at.jku.isse.gradient.model.CanonicalEntity {

    var versions: MutableSet<Version> = mutableSetOf()
    var lastVersion: Version? = null


    constructor()
    constructor(id: String,
                name: String,
                canonicalName: String,
                versions: List<Version>) : super(id, name, canonicalName) {
        this.versions.addAll(versions)
        if (versions.isNotEmpty()) {
            lastVersion = versions.last()
        }
    }

    override fun toString(): String {
        return "Project(id='$canonicalName')"
    }

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitProject(this)
}