package at.jku.isse.gradient.dal

import at.jku.isse.gradient.model.*

class LabelVisitor {

    fun labelOf(model: at.jku.isse.gradient.model.ModelVisitable): String {
        return Visitor().run {
            scan(model)
            label
        }
    }

    private inner class Visitor : at.jku.isse.gradient.model.ModelVisitor {

        var label: String = ""

        override fun visitAccess(e: Access) {
            label = ":Access"
        }

        override fun visitElementType(e: ElementType) {
            label = ":ElementType"
        }

        override fun visitType(e: Type) {
            label = ":Type:Versionable"
        }

        override fun visitProperty(e: Property) {
            label = ":Property:Versionable"
        }

        override fun visitExecutable(e: Executable) {
            label = ":Executable:Versionable"
        }

        override fun visitInvocation(e: Invocation) {
            label = ":Invocation"
        }

        override fun visitParameter(e: Parameter) {
            label = ":Parameter"
        }

        override fun visitProject(e: Project) {
            label = ":Project"
        }

        override fun visitTypeParameterMapping(e: TypeParameterMapping) {
            label = ":TypeParameter"
        }

        override fun visitVersion(e: Version) {
            label = ":Version"
        }

        override fun visitOverriding(e: Overriding) {
            label = ":Overriding"
        }
    }
}