package at.jku.isse.gradient

import at.jku.isse.gradient.dal.DalModule
import at.jku.isse.gradient.monitoring.MonitoringModule
import com.google.inject.Guice
import com.google.inject.Injector
import com.google.inject.Module

class Gradient {
    companion object {
        private var injector: Injector? = null
    }

    private val modules: MutableSet<Module> = mutableSetOf(GradientModule(), DalModule(), MonitoringModule())

    fun registerAdditionalModules(modules: Iterable<Module>) {
        this.modules.addAll(modules)
    }

    fun bootstrapGradient(): Injector {
        if (injector == null) {
            injector = Guice.createInjector(modules)
        }

        return injector!!
    }
}
