package at.jku.isse.gradient.model

class Value private constructor(override var id: String, val elementName: String, val value: Any, val type: Type) : at.jku.isse.gradient.model.Entity {
    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitValue(this)


    internal enum class Type {
        NUMBER, REFERENCE, TEXT, UNKNOWN, NONE
    }

    override fun toString(): String {
        return "Value{" +
                "value=" + value +
                ", type=" + type +
                '}'
    }

    companion object {
        fun fromObject(id: String, elementName: String, newState: Any?): Value = when (newState) {
            is Number -> Value(id, elementName, newState, Type.NUMBER)
            is String -> Value(id, elementName, newState, Type.TEXT)
            is __Gradient_Observable__ -> Value(id, elementName, newState.__gradient_id__(), Type.REFERENCE)
            else ->
                if (newState == null) {
                    Value(id, elementName, "void", Type.NONE)
                } else {
                    Value(id, elementName, newState.hashCode(), Type.UNKNOWN)
                }

        }
    }
}
