package at.jku.isse.gradient.model


enum class AccessType(val value: String) {
    READ("<-"), WRITE("->"), FULL("<->")
}

enum class Cardinality(val value: String) {
    ONE(""), N("+"), UNBOUND("*")
}

enum class Quality {
    CONCRETE, PARTIAL, PURE
}

enum class Availability {
    SOURCE, BINARY, UNAVAILABLE
}

enum class Visibility {
    PRIVATE, INHERITANCE, PUBLIC
}

enum class Accessor {
    SETTER, GETTER, NONE
}

enum class OverridingQuality {
    /** The overriding executable uses the service of the overriding executable but also adds new implementation details.*/
    EXTENDING,
    /** The overriding executable uses not the service of the overriding executable but only adds own implementation details.*/
    REPLACING,
    /** The overriding executable declares and empty body of, hence clears any existing implementation.*/
    CLEARING,
    /** The overriding executable is only calling a super executable different from its overriding executable to revert the original behavior.*/
    REVERTING,
    /** The overriding executable is deferring the service to its super implementation.*/
    DEFERRING,
    /** The overriding executable is implementing an abstract executable. */
    IMPLEMENTING,
    /** The overriding executable is redeclaring an existing abstract executable without implementing it*/
    REDECLARING
}