package at.jku.isse.gradient.model

class Overriding(id: String,
                 canonicalName: String,
                 val source: Executable,
                 val target: Executable,
                 val overridingQuality: OverridingQuality) : at.jku.isse.gradient.model.CanonicalEntity(id, canonicalName, canonicalName) {

    companion object {
        fun canonicalNameOf(source: Executable,
                            target: Executable,
                            overridingQuality: OverridingQuality): String {
            return "${source.canonicalName} -[${overridingQuality.name}]-> ${target.canonicalName}"
        }
    }

    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) = visitor.visitOverriding(this)
}