package at.jku.isse.gradient.model

import java.io.Serializable

data class Observation(override var id: String,
                       val objectId: String,
                       val observeeName: String,
                       val executableContext: String,
                       val values: List<Value>,
                       val type: EventType,
                       var previousObservationId: String?) : at.jku.isse.gradient.model.Entity, Serializable {


    override fun accept(visitor: at.jku.isse.gradient.model.ModelVisitor) {
        visitor.visitObservation(this)
    }

    enum class EventType {
        READ, WRITE, CALL, RETURN
    }
}
