package at.jku.isse.gradient.dal.mongo

import at.jku.isse.gradient.GradientConfig
import com.mongodb.client.MongoClient
import com.mongodb.client.MongoClients
import com.mongodb.client.model.Indexes
import mu.KotlinLogging
import org.aeonbits.owner.ConfigFactory

private val logger = KotlinLogging.logger {}

internal object MongoConfiguration {
    fun configure(runtimeCollection: String): Pair<MongoClient, Runnable> {
        logger.debug { "Creating indexes" }

        val config = ConfigFactory.create(GradientConfig::class.java)
        val client = MongoClients.create(config.mongoConnectionString())

        val collection = client.getDatabase("dynamic-analysis")
                .getCollection(runtimeCollection)
        collection.createIndex(Indexes.ascending("observeeName"))
        collection.createIndex(Indexes.ascending("type"))
        collection.createIndex(Indexes.ascending("executableContext"))
        collection.createIndex(Indexes.ascending("parentExecutableContext"))
        collection.createIndex(Indexes.ascending("values.elementName"))

        val cleanup = Runnable {
            client.close()
        }

        return Pair(client, cleanup)
    }
}