package at.jku.isse.gradient.dal.mongo

import at.jku.isse.gradient.dal.ObservationDao
import at.jku.isse.gradient.dal.QueryDao
import com.google.inject.Inject
import com.mongodb.client.MongoClient
import mu.KotlinLogging
import org.bson.Document

private val logger = KotlinLogging.logger {}

class BatchMongoObservationDao
@Inject constructor(private val mongoClient: MongoClient,
                    private val dao: QueryDao) : ObservationDao {

    override fun reportObservationBatch(projectName: String, versionId: String, runtimeId: String,
                                        observationBatch: List<Map<String, Any>>) {
        if (observationBatch.isEmpty())
            return
        logger.debug { "Preparing documents: ${observationBatch.size} observations" }
        val documents = observationBatch.map { Document(it) }

        logger.debug { "Creating new session" }
        val collection = mongoClient.getDatabase("dynamic-analysis")
                .getCollection(runtimeId)

        logger.debug { "Writing data" }
        collection.insertMany(documents)
        reportToNeo4j(projectName, versionId, runtimeId)
    }

    private fun reportToNeo4j(projectName: String, versionId: String, runtimeId: String) {
        val query = """
                    MATCH (:Project {canonicalName:{projectName}})
                            -[:contains]-> (v:Version {id:{versionId}})
                    MERGE (v) -[:observed]-> (:Dynamics {collectionId:{collectionId}})
                    """.trimIndent()

        dao.query(
                query,
                mapOf("projectName" to projectName,
                        "versionId" to versionId,
                        "collectionId" to runtimeId)
        )
    }
}