package at.jku.isse.gradient

import org.aeonbits.owner.Config
import org.aeonbits.owner.Config.DefaultValue
import org.aeonbits.owner.Config.Key
import java.io.File

@Config.Sources("classpath:gradient.properties")
interface GradientConfig : Config {

    @Key("gradientFolder")
    @DefaultValue(".gradient")
    fun gradientFolder(): File

    @Key("gradient.client.observationCache")
    @DefaultValue("1000")
    fun observationCacheSize(): Int

    @Key("gradient.server.host")
    @DefaultValue("localhost")
    fun gradientServerHost(): String

    @Key("gradient.server.port")
    @DefaultValue("50051")
    fun gradientServerPort(): Int

    @Config.Key("neo4j.connectionString")
    @Config.DefaultValue("bolt://localhost:7687")
    fun neo4jConnectionString(): String

    @Config.Key("neo4j.username")
    @Config.DefaultValue("neo4j")
    fun neo4jUsername(): String

    @Config.Key("neo4j.password")
    @Config.DefaultValue("password")
    fun neo4jPassword(): String

    @Config.Key("neo4j.logLevel")
    @Config.DefaultValue("INFO")
    fun neo4jLogLevel(): String

    @Config.Key("mongo.connectionString")
    @Config.DefaultValue("mongodb://localhost:27017/?compressor=zlib")
    fun mongoConnectionString(): String
}