/*
 * Decompiled with CFR 0.152.
 */
package at.jku.isse.gradient.monitoring;

import at.jku.isse.gradient.Gradient;
import at.jku.isse.gradient.runtime.__Gradient_Observable__;
import at.jku.isse.gradient.service.EventService;
import com.google.common.primitives.Primitives;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class Monitor {
    private static final Logger logger = LoggerFactory.getLogger(Monitor.class);
    private static final UUID EMPTY_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public boolean monitoringEnabled;
    @Inject
    private EventService eventService;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ Monitor ajc$perSingletonInstance;

    public Monitor() {
        logger.debug("Configuring monitoring aspect");
        Gradient gradient = Gradient.Companion.getDefaultInstance();
        Injector injector = gradient.bootstrapGradient();
        injector.injectMembers((Object)this);
        boolean bl = this.monitoringEnabled = this.eventService != null;
        if (!this.monitoringEnabled) {
            logger.warn("No event service is provided thus disabling monitor.");
        }
    }

    @Pointcut(value="target(contextObject) && !target(at.jku.isse.gradient.runtime.__TimeBased_Gradient_Observable__) &&set(* at.jku.isse.gradient.runtime.__Gradient_Observable__+.*) && args(obj)", argNames="contextObject,obj")
    public void propertyWrite(__Gradient_Observable__ contextObject, Object obj) {
    }

    @Pointcut(value="target(contextObject) && !target(at.jku.isse.gradient.runtime.__TimeBased_Gradient_Observable__) &&get(* at.jku.isse.gradient.runtime.__Gradient_Observable__+.*)", argNames="contextObject")
    public void propertyRead(__Gradient_Observable__ contextObject) {
    }

    @Pointcut(value="!target(at.jku.isse.gradient.runtime.__TimeBased_Gradient_Observable__) && execution(static * at.jku.isse.gradient.runtime.__Gradient_Observable__+.*(..))")
    public void executableStatic() {
    }

    @Pointcut(value="target(contextObject) &&!target(at.jku.isse.gradient.runtime.__TimeBased_Gradient_Observable__) &&(execution(void at.jku.isse.gradient.runtime.__Gradient_Observable__+.*(..)) ||    execution(at.jku.isse.gradient.runtime.__Gradient_Observable__+.new(..)))", argNames="contextObject")
    public void executableVoid(__Gradient_Observable__ contextObject) {
    }

    @Pointcut(value="target(contextObject) &&!target(at.jku.isse.gradient.runtime.__TimeBased_Gradient_Observable__) &&!execution(void at.jku.isse.gradient.runtime.__Gradient_Observable__+.*(..)) &&execution(* at.jku.isse.gradient.runtime.__Gradient_Observable__+.*(..))", argNames="contextObject")
    public void executableReturning(__Gradient_Observable__ contextObject) {
    }

    @After(value="propertyWrite(contextObject, obj)", argNames="thisJoinPointStaticPart,contextObject,obj")
    public void propertyWriteAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject, Object obj) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (thisJoinPointStaticPart != null && contextObject != null);
        Signature signature = thisJoinPointStaticPart.getSignature();
        String elementName = signature.getDeclaringTypeName() + "#" + signature.getName();
        try {
            this.eventService.reportPropertyWrite(elementName, contextObject.__gradient_id__(), obj);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ propertyWriteAdvice", elementName));
        }
    }

    @AfterReturning(pointcut="propertyRead(contextObject)", returning="obj", argNames="thisJoinPointStaticPart,contextObject,obj")
    public void propertyReadAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject, Object obj) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (thisJoinPointStaticPart != null && contextObject != null);
        Signature signature = thisJoinPointStaticPart.getSignature();
        String elementName = signature.getDeclaringTypeName() + "#" + signature.getName();
        try {
            this.eventService.reportPropertyRead(elementName, contextObject.__gradient_id__(), obj);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ propertyReadAdvice", elementName));
        }
    }

    @Before(value="executableStatic()", argNames="thisJoinPoint,thisJoinPointStaticPart")
    public void executableStaticCallAdvice(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (thisJoinPointStaticPart != null);
        String elementName = this.canonicalExecutableName((CodeSignature)thisJoinPointStaticPart.getSignature());
        this.executableCallAdviceHandler(thisJoinPoint, elementName, EMPTY_UUID);
    }

    @Before(value="executableReturning(contextObject) || executableVoid(contextObject)", argNames="thisJoinPoint,thisJoinPointStaticPart,contextObject")
    public void executableCallAdvice(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (contextObject != null && thisJoinPointStaticPart != null);
        String elementName = this.canonicalExecutableName((CodeSignature)thisJoinPointStaticPart.getSignature());
        this.executableCallAdviceHandler(thisJoinPoint, elementName, contextObject.__gradient_id__());
    }

    private void executableCallAdviceHandler(JoinPoint thisJoinPoint, String elementName, UUID gradientId) {
        try {
            this.eventService.reportExecutableCall(elementName, gradientId);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ executableCallAdvice (call)", elementName));
        }
        try {
            Object[] arguments = thisJoinPoint.getArgs();
            for (int i = 0; i < arguments.length; ++i) {
                String parameterName = elementName + "#" + i;
                this.eventService.reportExecutableParameter(parameterName, gradientId, arguments[i]);
            }
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ executableCallAdvice (parameters)", elementName));
        }
    }

    @AfterReturning(value="executableStatic()", returning="obj", argNames="thisJoinPointStaticPart,obj")
    public void executableStaticReturningAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, Object obj) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (thisJoinPointStaticPart != null);
        String elementName = this.canonicalExecutableName((CodeSignature)thisJoinPointStaticPart.getSignature());
        try {
            this.eventService.reportExecutableReturn(elementName, EMPTY_UUID, obj);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ executableReturnAdvice", elementName));
        }
    }

    @AfterReturning(value="executableReturning(contextObject)", returning="obj", argNames="thisJoinPointStaticPart,contextObject,obj")
    public void executableReturnAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject, Object obj) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (contextObject != null && thisJoinPointStaticPart != null);
        String elementName = this.canonicalExecutableName((CodeSignature)thisJoinPointStaticPart.getSignature());
        try {
            this.eventService.reportExecutableReturn(elementName, contextObject.__gradient_id__(), obj);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ executableReturnAdvice", elementName));
        }
    }

    @AfterReturning(value="executableVoid(contextObject)", argNames="thisJoinPointStaticPart,contextObject")
    public void executableReturnVoidAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (contextObject != null && thisJoinPointStaticPart != null);
        String elementName = this.canonicalExecutableName((CodeSignature)thisJoinPointStaticPart.getSignature());
        try {
            this.eventService.reportExecutableReturn(elementName, contextObject.__gradient_id__(), null);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ executableReturnVoidAdvice", elementName));
        }
    }

    @AfterThrowing(value="executableStatic()", throwing="exception", argNames="thisJoinPointStaticPart,exception")
    public void executableStaticThrowingAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, Throwable exception) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (thisJoinPointStaticPart != null);
        String elementName = this.canonicalExecutableName((CodeSignature)thisJoinPointStaticPart.getSignature());
        try {
            this.eventService.reportExecutableException(elementName, EMPTY_UUID, exception);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ executableThrowingAdvice", elementName));
        }
    }

    @AfterThrowing(value="executableReturning(contextObject) || executableVoid(contextObject)", throwing="exception", argNames="thisJoinPointStaticPart,contextObject,exception")
    public void executableThrowingAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject, Throwable exception) {
        if (!this.monitoringEnabled) {
            return;
        }
        assert (contextObject != null && thisJoinPointStaticPart != null);
        String elementName = this.canonicalExecutableName((CodeSignature)thisJoinPointStaticPart.getSignature());
        try {
            this.eventService.reportExecutableException(elementName, contextObject.__gradient_id__(), exception);
        }
        catch (Exception e) {
            logger.debug(String.format("Could not report event: %s @ executableThrowingAdvice", elementName));
        }
    }

    private String canonicalExecutableName(CodeSignature signature) {
        assert (signature != null);
        String declaringType = signature.getDeclaringTypeName();
        String element = Objects.equals(signature.getName(), "<init>") ? signature.getDeclaringType().getSimpleName() : signature.getName();
        String parameters = Arrays.stream(signature.getParameterTypes()).map(Primitives::wrap).map(Class::getTypeName).collect(Collectors.joining(", "));
        return String.format("%s#%s(%s)", declaringType, element, parameters);
    }

    static {
        try {
            Monitor.ajc$perSingletonInstance = new Monitor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static Monitor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("at.jku.isse.gradient.monitoring.Monitor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

