package at.jku.isse.gradient.model

import at.jku.isse.gradient.runtime.__Gradient_Observable__
import java.util.*

class Value private constructor(override var id: UUID, val elementName: String, val value: Any, val type: Type) : at.jku.isse.gradient.model.Entity {

    internal enum class Type {
        NUMBER, REFERENCE, TEXT, UNKNOWN, NONE
    }

    override fun toString(): String {
        return "Value{" +
                "value=" + value +
                ", type=" + type +
                '}'
    }

    companion object {
        fun fromObject(id: UUID, elementName: String, newState: Any?): Value = when (newState) {
            is Number -> Value(id, elementName, newState, Type.NUMBER)
            is String -> Value(id, elementName, newState, Type.TEXT)
            is __Gradient_Observable__ -> Value(id, elementName, newState.__gradient_id__(), Type.REFERENCE)
            else ->
                if (newState == null) {
                    Value(id, elementName, "void", Type.NONE)
                } else {
                    Value(id, elementName, newState.hashCode(), Type.UNKNOWN)
                }

        }
    }
}
