package at.jku.isse.gradient.monitoring;

import at.jku.isse.gradient.Gradient;
import at.jku.isse.gradient.dal.StructuralDao;
import com.google.inject.Inject;
import com.google.inject.Injector;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclareParents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


@Aspect
@SuppressWarnings("unused")
public class ObservableWeaver {
    private static final Logger logger = LoggerFactory.getLogger(ObservableWeaver.class);

    private final Gradient gradient = MonitoringContext.gradient;

    @Inject
    private StructuralCache structuralCache;

    @Inject
    private StructuralDao structuralDao;

    ObservableWeaver() {
        logger.debug("Configuring dynamic observable weaver");
        Injector injector = MonitoringContext.gradient.bootstrapGradient();
        injector.injectMembers(this);
    }

    @DeclareParents(
            value = "@at.jku.isse.gradient.annotations.GradientModel *",
            defaultImpl = __Gradient_Observable_Impl__.class
    )
    private __Gradient_Observable__ implementedInterface;

    @After(value = "staticinitialization(!at.jku.isse.gradient.monitoring.__Gradient_Observable_Impl__ && at.jku.isse.gradient.monitoring.__Gradient_Observable__+)")
    public void repairDynamicGradientModels(JoinPoint joinPoint) {
        structuralDao.registerAdditionalGradientModel(
                structuralCache.getProjectName(),
                structuralCache.getVersionId(),
                joinPoint.getSignature().getDeclaringTypeName()
        );
    }
}

