/*
 * Decompiled with CFR 0.152.
 */
package at.jku.isse.gradient.monitoring;

import at.jku.isse.gradient.GradientConfig;
import at.jku.isse.gradient.dal.Cleanup;
import at.jku.isse.gradient.model.Observation;
import at.jku.isse.gradient.monitoring.MonitoringUtil;
import at.jku.isse.gradient.monitoring.StructuralCache;
import at.jku.isse.gradient.monitoring.__Gradient_Observable__;
import at.jku.isse.gradient.service.BehavioralService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.primitives.Primitives;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class Monitor {
    private static final Logger logger = LoggerFactory.getLogger(Monitor.class);
    private final ThreadLocal<String> processId = ThreadLocal.withInitial(MonitoringUtil::uuid);
    @Inject
    private GradientConfig gradientConfig;
    @Inject
    @Named(value="runtimeId")
    private String runtimeId;
    @Inject
    private StructuralCache structuralCache;
    @Inject
    private BehavioralService behavioralService;
    @Inject
    @Named(value="cleanupBus")
    private EventBus cleanupBus;
    private final List<Map<String, Object>> buffer = new ArrayList<Map<String, Object>>();
    private List<String> executableContext = new ArrayList<String>();
    private boolean reportErrorIssued = false;

    Monitor() {
        if (this.cleanupBus != null) {
            this.cleanupBus.register((Object)this);
        } else {
            logger.warn("Eventbus is not present; hence cleanup may not be possible.");
        }
    }

    @Pointcut(value="target(contextObject) && set(* *) && args(newState)", argNames="contextObject,newState")
    void fieldWrite(__Gradient_Observable__ contextObject, Object newState) {
    }

    @Pointcut(value="target(contextObject) && get(* *)", argNames="contextObject")
    void fieldRead(__Gradient_Observable__ contextObject) {
    }

    @Pointcut(value="target(contextObject) && !initialization(at.jku.isse.gradient.monitoring.__Gradient_Observable__.new()) && initialization(*.new(..))", argNames="contextObject")
    void construction(__Gradient_Observable__ contextObject) {
    }

    @Pointcut(value="target(contextObject) && !initialization(at.jku.isse.gradient.monitoring.__Gradient_Observable__.new()) &&!execution(java.lang.String at.jku.isse.gradient.monitoring.__Gradient_Observable__.__gradient_id__()) &&execution(* *.*(..))", argNames="contextObject")
    void invocation(__Gradient_Observable__ contextObject) {
    }

    private ImmutableMap<String, Object> parseObservationValue(String elementName, Object newState) {
        if (newState instanceof Number) {
            return ImmutableMap.of((Object)"elementName", (Object)elementName, (Object)"value", (Object)newState, (Object)"type", (Object)"NUMBER");
        }
        if (newState instanceof String) {
            return ImmutableMap.of((Object)"elementName", (Object)elementName, (Object)"value", (Object)newState, (Object)"type", (Object)"TEXT");
        }
        if (newState instanceof __Gradient_Observable__) {
            return ImmutableMap.of((Object)"elementName", (Object)elementName, (Object)"value", (Object)((__Gradient_Observable__)newState).__gradient_id__(), (Object)"type", (Object)"REFERENCE");
        }
        if (newState == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)"elementName", (Object)elementName, (Object)"value", (Object)newState.hashCode(), (Object)"type", (Object)"UNKNOWN");
    }

    @After(value="fieldWrite(contextObject, newState)", argNames="thisJoinPointStaticPart,contextObject,newState")
    public void fieldWriteAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject, Object newState) {
        ImmutableList values;
        Signature signature = thisJoinPointStaticPart.getSignature();
        String elementName = signature.getDeclaringTypeName() + "#" + signature.getName();
        ImmutableMap.Builder observation = ImmutableMap.builder().put((Object)"id", (Object)MonitoringUtil.uuid()).put((Object)"processId", (Object)this.processId.get()).put((Object)"objectId", (Object)contextObject.__gradient_id__()).put((Object)"timestamp", (Object)Instant.now().toEpochMilli()).put((Object)"observeeName", (Object)elementName).put((Object)"type", (Object)Observation.EventType.WRITE.name()).put((Object)"executableContext", (Object)this.executableContext.get(this.executableContext.size() - 1));
        if (this.executableContext.size() - 2 > -1) {
            observation.put((Object)"parentExecutableContext", (Object)this.executableContext.get(this.executableContext.size() - 2));
        }
        if (!(values = ImmutableList.of(this.parseObservationValue(elementName, newState))).isEmpty()) {
            observation.put((Object)"writes", (Object)values);
        }
        this.reportObservation((Map<String, Object>)observation.build());
    }

    @AfterReturning(pointcut="fieldRead(contextObject)", returning="field", argNames="thisJoinPointStaticPart,contextObject,field")
    public void fieldReadAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject, Object field) {
        ImmutableList values;
        Signature signature = thisJoinPointStaticPart.getSignature();
        String elementName = signature.getDeclaringTypeName() + "#" + signature.getName();
        ImmutableMap.Builder observation = ImmutableMap.builder().put((Object)"id", (Object)MonitoringUtil.uuid()).put((Object)"processId", (Object)this.processId.get()).put((Object)"objectId", (Object)contextObject.__gradient_id__()).put((Object)"timestamp", (Object)Instant.now().toEpochMilli()).put((Object)"observeeName", (Object)elementName).put((Object)"type", (Object)Observation.EventType.READ.name()).put((Object)"executableContext", (Object)this.executableContext.get(this.executableContext.size() - 1));
        if (this.executableContext.size() - 2 > -1) {
            observation.put((Object)"parentExecutableContext", (Object)this.executableContext.get(this.executableContext.size() - 2));
        }
        if (!(values = ImmutableList.of(this.parseObservationValue(elementName, field))).isEmpty()) {
            observation.put((Object)"reads", (Object)values);
        }
        this.reportObservation((Map<String, Object>)observation.build());
    }

    @After(value="construction(contextObject)", argNames="thisJoinPoint,thisJoinPointStaticPart,contextObject")
    public void constructionAdvice(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject) {
        this.callAdvice(thisJoinPoint, thisJoinPointStaticPart, contextObject);
    }

    @Before(value="invocation(contextObject)", argNames="thisJoinPoint,thisJoinPointStaticPart,contextObject")
    public void invocationBeforeAdvice(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject) {
        this.callAdvice(thisJoinPoint, thisJoinPointStaticPart, contextObject);
    }

    @AfterReturning(value="invocation(contextObject)", returning="returnValue", argNames="thisJoinPointStaticPart,contextObject,returnValue")
    public void invocationAfterAdvice(JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject, Object returnValue) {
        assert (thisJoinPointStaticPart.getSignature() instanceof CodeSignature) : "Expected method selected via pointcut";
        CodeSignature signature = (CodeSignature)thisJoinPointStaticPart.getSignature();
        Map<String, Object> observation = this.afterExecutable(contextObject, signature, returnValue);
        this.executableContext.remove(this.executableContext.size() - 1);
        this.reportObservation(observation);
    }

    public void reset() {
        this.buffer.clear();
        if (this.isInitialized()) {
            this.structuralCache.reload();
        } else {
            logger.warn("Could not fully reset the aspect as it was not proper initialized.");
        }
    }

    @Subscribe
    public void cleanupSignal(Cleanup cleanup) {
        this.flush();
        if (this.isInitialized()) {
            this.behavioralService.reportObservationEnd(this.structuralCache.getProjectName(), this.structuralCache.getVersionId(), this.runtimeId);
        } else {
            logger.warn("Could not cleanup as the aspectj was not fully initialized.");
        }
    }

    public boolean isInitialized() {
        return this.gradientConfig != null && this.runtimeId != null && this.structuralCache != null && this.behavioralService != null && this.cleanupBus != null;
    }

    private void callAdvice(JoinPoint thisJoinPoint, JoinPoint.StaticPart thisJoinPointStaticPart, __Gradient_Observable__ contextObject) {
        assert (thisJoinPointStaticPart.getSignature() instanceof CodeSignature) : "Expected method selected via pointcut";
        this.executableContext.add(MonitoringUtil.uuid());
        CodeSignature signature = (CodeSignature)thisJoinPointStaticPart.getSignature();
        Object[] arguments = thisJoinPoint.getArgs();
        Map<String, Object> observation = this.beforeExecutable(contextObject, signature, arguments);
        this.reportObservation(observation);
    }

    private Map<String, Object> beforeExecutable(__Gradient_Observable__ contextObject, CodeSignature signature, Object[] arguments) {
        String[] parameters = signature.getParameterNames();
        String elementName = this.canonicalExecutableName(signature);
        assert (arguments.length == parameters.length);
        ImmutableMap.Builder observation = ImmutableMap.builder().put((Object)"id", (Object)MonitoringUtil.uuid()).put((Object)"processId", (Object)this.processId.get()).put((Object)"objectId", (Object)contextObject.__gradient_id__()).put((Object)"timestamp", (Object)Instant.now().toEpochMilli()).put((Object)"observeeName", (Object)elementName).put((Object)"type", (Object)Observation.EventType.CALL.name()).put((Object)"executableContext", (Object)this.executableContext.get(this.executableContext.size() - 1));
        if (this.executableContext.size() - 2 > -1) {
            observation.put((Object)"parentExecutableContext", (Object)this.executableContext.get(this.executableContext.size() - 2));
        }
        ArrayList<ImmutableMap<String, Object>> values = new ArrayList<ImmutableMap<String, Object>>(arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            values.add(this.parseObservationValue(elementName + "#" + i, arguments[i]));
        }
        if (!values.isEmpty()) {
            observation.put((Object)"receives", values);
        }
        return observation.build();
    }

    private Map<String, Object> afterExecutable(__Gradient_Observable__ contextObject, CodeSignature signature, Object returnValue) {
        ImmutableMap<String, Object> value;
        String elementName = this.canonicalExecutableName(signature);
        ImmutableMap.Builder observation = ImmutableMap.builder().put((Object)"id", (Object)MonitoringUtil.uuid()).put((Object)"processId", (Object)this.processId.get()).put((Object)"objectId", (Object)contextObject.__gradient_id__()).put((Object)"timestamp", (Object)Instant.now().toEpochMilli()).put((Object)"observeeName", (Object)elementName).put((Object)"type", (Object)Observation.EventType.RETURN.name()).put((Object)"executableContext", (Object)this.executableContext.get(this.executableContext.size() - 1));
        if (this.executableContext.size() - 2 > -1) {
            observation.put((Object)"parentExecutableContext", (Object)this.executableContext.get(this.executableContext.size() - 2));
        }
        if (!(value = this.parseObservationValue(elementName, returnValue)).isEmpty()) {
            observation.put((Object)"returns", (Object)ImmutableList.of(value));
        }
        return observation.build();
    }

    private String canonicalExecutableName(CodeSignature signature) {
        String declaringType = signature.getDeclaringTypeName();
        String element = Objects.equals(signature.getName(), "<init>") ? signature.getDeclaringType().getSimpleName() : signature.getName();
        String parameters = Arrays.stream(signature.getParameterTypes()).map(Primitives::wrap).map(Class::getTypeName).collect(Collectors.joining(", "));
        return String.format("%s#%s(%s)", declaringType, element, parameters);
    }

    private void flush() {
        this.behavioralService.report(this.structuralCache.getProjectName(), this.structuralCache.getVersionId(), this.runtimeId, this.buffer);
        this.buffer.clear();
    }

    private void reportObservation(Map<String, Object> observation) {
        if (this.isInitialized()) {
            if (this.buffer.size() + 1 > this.gradientConfig.observationCacheSize()) {
                this.flush();
            }
        } else {
            if (!this.reportErrorIssued) {
                logger.error("Services are not initialized; hence observations will be discarded.");
                this.reportErrorIssued = true;
            }
            this.buffer.clear();
        }
        this.buffer.add(observation);
    }
}

