/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.servlet.ServletConfigurationError;
import at.ipsquare.commons.servlet.UnitOfWorkFilter;
import at.ipsquare.commons.servlet.UnitTestFilterConfig;
import at.ipsquare.hibernate.ExecutionError;
import at.ipsquare.hibernate.HibernateRepository;
import at.ipsquare.hibernate.UnitOfWork;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import org.hibernate.Session;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.annotations.Test;

public class TestUnitOfWorkFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilter() throws ServletException {
        UnitOfWorkFilter filter = new UnitOfWorkFilter();
        filter.init(TestUnitOfWorkFilter.validTestFilterConfig());
        try {
            TestUnitOfWorkFilter.doFilter((Filter)filter, "/foo", new TestFilterChainOk(), null);
            TestUnitOfWorkFilter.doFilter((Filter)filter, "/foo.jpg", new TestFilterChainOk(), null);
            TestUnitOfWorkFilter.doFilter((Filter)filter, "/foo", new TestFilterChainSevletException(), RuntimeException.class);
            TestUnitOfWorkFilter.doFilter((Filter)filter, "/foo", new TestFilterChainIoException(), RuntimeException.class);
            TestUnitOfWorkFilter.doFilter((Filter)filter, "/foo", new TestFilterChainRuntimeException(), RuntimeException.class);
        }
        finally {
            filter.destroy();
        }
        Assert.assertEquals((int)2, (int)TestHibernateRepository.unitsProcessedOk.get());
        Assert.assertEquals((int)6, (int)TestHibernateRepository.unitsProcessedError.get());
    }

    private static FilterConfig validTestFilterConfig() {
        return new UnitTestFilterConfig(TestUnitOfWorkFilter.validTestFilterConfigProperties());
    }

    private static Map<String, String> validTestFilterConfigProperties() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("repo1", "at.ipsquare.commons.servlet.TestUnitOfWorkFilter$TestRepositoryProvider1");
        props.put("repo2", "at.ipsquare.commons.servlet.TestUnitOfWorkFilter$TestRepositoryProvider2");
        props.put("includePathPattern", ".*");
        props.put("excludePathPattern", ".*\\.jpg");
        return props;
    }

    @Test
    public void testInit() {
        Map<String, String> props = new HashMap<String, String>();
        TestUnitOfWorkFilter.testInit(props, null);
        props = TestUnitOfWorkFilter.validTestFilterConfigProperties();
        TestUnitOfWorkFilter.testInit(props, null);
        props.put("", "");
        TestUnitOfWorkFilter.testInit(props, RuntimeException.class);
        props.remove("");
        props.put("duplicate", "at.ipsquare.commons.servlet.TestUnitOfWorkFilter$TestRepositoryProvider1");
        TestUnitOfWorkFilter.testInit(props, ServletConfigurationError.class);
    }

    private static void testInit(Map<String, String> properties, Class<? extends Throwable> expectedException) {
        try {
            UnitOfWorkFilter filter = new UnitOfWorkFilter();
            filter.init((FilterConfig)new UnitTestFilterConfig(properties));
            if (expectedException != null) {
                Assert.fail((String)"Exception expected.");
            }
        }
        catch (Throwable th) {
            TestUnitOfWorkFilter.expectException(th, expectedException);
        }
    }

    private static void doFilter(Filter filter, String path, FilterChain chain, Class<? extends Throwable> expectedException) {
        try {
            filter.doFilter(TestUnitOfWorkFilter.requestFromPath(path), null, chain);
            if (expectedException != null) {
                Assert.fail((String)"Exception expected.");
            }
        }
        catch (Throwable th) {
            TestUnitOfWorkFilter.expectException(th, expectedException);
        }
    }

    private static ServletRequest requestFromPath(String path) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo(path);
        req.setServletPath("");
        return req;
    }

    private static void expectException(Throwable th, Class<? extends Throwable> expectedException) {
        if (expectedException == null) {
            throw new RuntimeException(th);
        }
        if (!expectedException.isInstance(th)) {
            Assert.fail((String)("Expected " + expectedException.getSimpleName() + " but got  :" + th));
        }
    }

    private static class TestFilterChainRuntimeException
    implements FilterChain {
        private TestFilterChainRuntimeException() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            throw new RuntimeException("Ups!");
        }
    }

    private static class TestFilterChainIoException
    implements FilterChain {
        private TestFilterChainIoException() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            throw new IOException("Ups!");
        }
    }

    private static class TestFilterChainSevletException
    implements FilterChain {
        private TestFilterChainSevletException() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            throw new ServletException("Ups!");
        }
    }

    private static class TestFilterChainOk
    implements FilterChain {
        private TestFilterChainOk() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
        }
    }

    public static class TestRepositoryProvider2
    implements Provider<TestRepository2> {
        static final TestRepository2 repo = new TestHibernateRepository();

        public TestRepository2 get() {
            return repo;
        }
    }

    public static class TestRepositoryProvider1
    implements Provider<TestRepository1> {
        static final TestRepository1 repo = new TestHibernateRepository();

        public TestRepository1 get() {
            return repo;
        }
    }

    private static class TestHibernateRepository
    implements TestRepository1,
    TestRepository2 {
        static final AtomicInteger unitsProcessedOk = new AtomicInteger();
        static final AtomicInteger unitsProcessedError = new AtomicInteger();

        private TestHibernateRepository() {
        }

        public Session currentSession() {
            return null;
        }

        public <T> T executeUnitOfWork(UnitOfWork<T> work) {
            T t;
            boolean ok = false;
            try {
                work.execute();
                ok = true;
                t = null;
                (ok ? unitsProcessedOk : unitsProcessedError).incrementAndGet();
            }
            catch (Exception e) {
                try {
                    throw new ExecutionError((Throwable)e);
                }
                catch (Throwable throwable) {
                    (ok ? unitsProcessedOk : unitsProcessedError).incrementAndGet();
                    throw throwable;
                }
            }
            return t;
        }
    }

    public static interface TestRepository2
    extends HibernateRepository {
    }

    public static interface TestRepository1
    extends HibernateRepository {
    }
}

