/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jcip.annotations.GuardedBy;

public final class ClassLoaders {
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static Set<WeakReference<ClassLoader>> clRefs = Collections.emptySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean register(ClassLoader cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        Object object = lock;
        synchronized (object) {
            Set<ClassLoader> cls = ClassLoaders.resolveWeakReferences(clRefs);
            boolean ret = cls.add(cl);
            if (ret) {
                clRefs = ClassLoaders.toWeakReferences(cls);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregister(ClassLoader cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        Object object = lock;
        synchronized (object) {
            Set<ClassLoader> resolved = ClassLoaders.resolveWeakReferences(clRefs);
            boolean ret = resolved.remove(cl);
            if (ret) {
                clRefs = ClassLoaders.toWeakReferences(resolved);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = lock;
        synchronized (object) {
            clRefs = Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ClassLoader> registered() {
        Object object = lock;
        synchronized (object) {
            return ClassLoaders.resolveWeakReferences(clRefs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ClassLoader> get() {
        Object object = lock;
        synchronized (object) {
            Set<ClassLoader> ret = ClassLoaders.resolveWeakReferences(clRefs);
            ret.add(ClassLoaders.class.getClassLoader());
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                ret.add(contextClassLoader);
            }
            return ret;
        }
    }

    private static Set<WeakReference<ClassLoader>> toWeakReferences(Set<ClassLoader> cls) {
        LinkedHashSet ret = Sets.newLinkedHashSetWithExpectedSize((int)cls.size());
        for (ClassLoader cl : cls) {
            ret.add(new WeakReference<ClassLoader>(cl));
        }
        return ret;
    }

    private static Set<ClassLoader> resolveWeakReferences(Set<WeakReference<ClassLoader>> cls) {
        LinkedHashSet ret = Sets.newLinkedHashSetWithExpectedSize((int)(cls.size() + 2));
        for (WeakReference<ClassLoader> clRef : cls) {
            ClassLoader cl = (ClassLoader)clRef.get();
            if (cl == null) continue;
            ret.add(cl);
        }
        return ret;
    }

    private ClassLoaders() {
    }
}

