/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.PerformanceLogTestUtils;
import at.ipsquare.commons.core.util.PerformanceLogger;
import at.ipsquare.commons.core.util.UnitTestAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TestPerformanceLoggerWithSpecialCases {
    @Test
    public void testDisableAndRenableLoggerWhileRunning() {
        String mark = TestPerformanceLoggerWithSpecialCases.mark(0);
        PerformanceLogTestUtils.enablePerformanceLogs(true);
        PerformanceLogger plog = new PerformanceLogger(0L);
        PerformanceLogTestUtils.enablePerformanceLogs(false);
        plog.logElapsed(mark);
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)mark)));
        plog.restart();
        PerformanceLogTestUtils.enablePerformanceLogs(true);
        plog.logElapsed(mark);
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.containsString((String)mark));
    }

    @Test
    public void testEnableAndDisableLoggerWhileRunning() {
        String mark = TestPerformanceLoggerWithSpecialCases.mark(1);
        PerformanceLogTestUtils.enablePerformanceLogs(false);
        PerformanceLogger plog = new PerformanceLogger(0L);
        PerformanceLogTestUtils.enablePerformanceLogs(true);
        plog.logElapsed(mark);
        plog.logElapsedAndRestart(mark);
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)mark)));
        plog.logElapsed(mark);
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.containsString((String)mark));
    }

    @AfterClass
    public static void afterClass() {
        PerformanceLogTestUtils.enablePerformanceLogs(true);
    }

    private static String mark(int i) {
        return TestPerformanceLoggerWithSpecialCases.class.getSimpleName() + "-mark-" + i;
    }
}

