/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.PerformanceLogTestUtils;
import at.ipsquare.commons.core.util.PerformanceLogger;
import at.ipsquare.commons.core.util.UnitTestAppender;
import ch.qos.logback.classic.Logger;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.slf4j.LoggerFactory;

@State(value=Scope.Benchmark)
public abstract class BenchPerformanceLogger {
    protected abstract boolean performanceLogsEnabled();

    @Setup(value=Level.Trial)
    public void configureLogger() {
        Logger logger = (Logger)LoggerFactory.getLogger(PerformanceLogger.class);
        UnitTestAppender.enabled = false;
        PerformanceLogTestUtils.enablePerformanceLogs(this.performanceLogsEnabled());
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        UnitTestAppender.enabled = true;
    }

    @Benchmark
    public void timedExecBelowThreshold() {
        PerformanceLogger.timedExec((long)100L, () -> {});
    }

    @Benchmark
    public void timedExecAboveThreshold() {
        PerformanceLogger.timedExec((long)0L, () -> {});
    }

    protected static void runBenchmark(Class<?> clazz) throws RunnerException {
        Options opts = new OptionsBuilder().include(Pattern.quote(clazz.getName())).mode(Mode.Throughput).timeUnit(TimeUnit.SECONDS).warmupIterations(3).measurementIterations(3).threads(1).forks(1).shouldDoGC(true).build();
        new Runner(opts).run();
    }
}

