/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.ClassLoaders;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.EnumerationUtils;

public final class LocalResources {
    public static File getFile(String path) throws IOException {
        URL url = LocalResources.getUrl(path);
        if ("jar".equals(url.getProtocol())) {
            throw new IOException(url + " points to a file that lies within a JAR file. Please use getUrl() or getStream() instead.");
        }
        File file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        if (!file.canRead()) {
            throw new IOException("Not readable: '" + file + "'.");
        }
        return file;
    }

    public static InputStream getStream(String path) throws IOException {
        return LocalResources.getUrl(path).openStream();
    }

    public static URL getUrl(String path) throws IOException {
        Set<ClassLoader> classLoaders = ClassLoaders.get();
        HashSet<String> urls = new HashSet<String>(2);
        for (ClassLoader cl : classLoaders) {
            URL url = LocalResources.getUrl(path, cl);
            if (url == null) continue;
            urls.add(url.toExternalForm());
        }
        if (urls.isEmpty()) {
            StringBuilder sb = new StringBuilder("'");
            sb.append(path).append("'");
            if (path.startsWith("/")) {
                sb.append("; try ommiting the leading '/'.");
            }
            sb.append("\n").append(LocalResources.classLoaderInfo(classLoaders));
            throw new FileNotFoundException(sb.toString());
        }
        if (urls.size() > 1) {
            throw new IOException("'" + path + "' : Ambiguous path.");
        }
        return new URL((String)urls.iterator().next());
    }

    private static String classLoaderInfo(Collection<ClassLoader> classLoaders) {
        StringBuilder sb = new StringBuilder("ClassLoaders involved:");
        for (ClassLoader cl : classLoaders) {
            sb.append("\n").append(LocalResources.classLoaderInfo(cl));
        }
        return sb.toString();
    }

    private static String classLoaderInfo(ClassLoader cl) {
        StringBuilder sb = new StringBuilder("** ");
        if (cl instanceof URLClassLoader) {
            URLClassLoader urlCl = (URLClassLoader)cl;
            sb.append("URLClassLoader -- ").append(LocalResources.collectClassLoaderUrls(urlCl));
        } else {
            sb.append(cl);
        }
        return sb.toString();
    }

    private static URL getUrl(String path, ClassLoader cl) throws IOException {
        List urls = EnumerationUtils.toList(cl.getResources(path));
        if (urls.isEmpty()) {
            return null;
        }
        if (urls.size() > 1) {
            throw new IOException("'" + path + "' : Ambiguous path; URLs: " + urls);
        }
        return (URL)urls.get(0);
    }

    private static Set<String> collectClassLoaderUrls(URLClassLoader cl) {
        TreeSet<String> urls = new TreeSet<String>();
        LocalResources.collectClassLoaderUrls(cl, urls);
        return urls;
    }

    private static void collectClassLoaderUrls(URLClassLoader cl, Set<String> accumulator) {
        for (URL url : cl.getURLs()) {
            accumulator.add(url.toString());
        }
        ClassLoader parent = cl.getParent();
        if (parent instanceof URLClassLoader) {
            LocalResources.collectClassLoaderUrls((URLClassLoader)parent, accumulator);
        }
    }

    private LocalResources() {
    }
}

