/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.LocalResources;
import at.ipsquare.commons.core.util.PerformanceLogger;
import at.ipsquare.commons.core.util.UnitTestAppender;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TestPerformanceLoggerWithSettingsFile {
    private static final String SETTING_SRC_BASE = "at/ipsquare/commons/core/util/_PerformanceLogger/";
    private static final String SETTINGS_FULL = "performanceLoggerFull.xml";
    private static final String SETTINGS_NO_THRESHOLD = "performanceLoggerNoThreshold.xml";
    private static final String SETTINGS_NO_FORMATTER = "performanceLoggerNoFormatter.xml";
    private static final String SETTINGS_INVALID_THRESHOLD = "performanceLoggerInvalidThreshold.xml";
    private static final String SETTINGS_INVALID_FORMATTER = "performanceLoggerInvalidFormatter.xml";
    private static final String SETTINGS_BROKEN_FORMATTER = "performanceLoggerBrokenFormatter.xml";

    private static void installDefaultSettingsFile(String basename) {
        try {
            File src = LocalResources.getFile((String)(SETTING_SRC_BASE + basename));
            FileUtils.copyFile((File)src, (File)TestPerformanceLoggerWithSettingsFile.defaultSettingsFile());
            PerformanceLogger.reloadDefaults();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void installDefaultSettingsFileAndResetTestAppender(String basename) {
        UnitTestAppender.reset();
        TestPerformanceLoggerWithSettingsFile.installDefaultSettingsFile(basename);
    }

    private static File defaultSettingsFile() throws IOException {
        File settingsDir = LocalResources.getFile((String)SETTING_SRC_BASE).getParentFile();
        return new File(settingsDir, "performanceLogger.xml");
    }

    @AfterClass
    public static void afterClass() {
        try {
            TestPerformanceLoggerWithSettingsFile.defaultSettingsFile().delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testWithFullSettings() throws InterruptedException {
        TestPerformanceLoggerWithSettingsFile.installDefaultSettingsFileAndResetTestAppender(SETTINGS_FULL);
        PerformanceLogger plog = new PerformanceLogger();
        plog.logElapsedAndRestart();
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.isEmptyString());
        Thread.sleep(6L);
        plog.logElapsed();
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.containsString((String)"***UnitTest***|"));
    }

    @Test
    public void testWithNoThreshold() throws InterruptedException {
        this.assertThatSomethingIsLogged(SETTINGS_NO_THRESHOLD);
    }

    @Test
    public void testWithNoFormatter() throws InterruptedException {
        this.assertThatSomethingIsLogged(SETTINGS_NO_FORMATTER);
    }

    @Test
    public void testWithInvalidFormatter() throws InterruptedException {
        this.assertThatSomethingIsLogged(SETTINGS_INVALID_FORMATTER, 0, "Upsala");
    }

    @Test
    public void testWithBrokenFormatter() throws InterruptedException {
        this.assertThatSomethingIsLogged(SETTINGS_BROKEN_FORMATTER, 0, "Damn");
    }

    @Test
    public void testWithInvalidThreshold() throws InterruptedException {
        this.assertThatSomethingIsLogged(SETTINGS_INVALID_THRESHOLD, 0, "NaN");
        this.assertThatSomethingIsLogged(SETTINGS_INVALID_THRESHOLD, 0, TestPerformanceLoggerWithSettingsFile.class.getSimpleName());
    }

    private void assertThatSomethingIsLogged(String settingsFile) throws InterruptedException {
        this.assertThatSomethingIsLogged(settingsFile, 0);
    }

    private void assertThatSomethingIsLogged(String settingsFile, int sleep) throws InterruptedException {
        this.assertThatSomethingIsLogged(settingsFile, sleep, null);
    }

    private void assertThatSomethingIsLogged(String settingsFile, int sleep, String catchword) throws InterruptedException {
        TestPerformanceLoggerWithSettingsFile.installDefaultSettingsFileAndResetTestAppender(settingsFile);
        PerformanceLogger plog = new PerformanceLogger();
        Thread.sleep(sleep);
        plog.logElapsed();
        if (catchword == null) {
            Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        } else {
            Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.containsString((String)catchword));
        }
    }
}

