/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.PerformanceLogger;
import at.ipsquare.commons.core.util.UnitTestAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TestPerformanceLoggerBlockBasedApi {
    @Test
    public void testTimedRunables() {
        String funName = "testTimedRunables";
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)funName)));
        boolean[] blockExecuted = new boolean[]{false};
        PerformanceLogger.timedExec(() -> {
            blockExecuted[0] = true;
        });
        Assert.assertTrue((boolean)blockExecuted[0]);
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.containsString((String)funName));
        blockExecuted[0] = false;
        String marker = funName + ":marker";
        PerformanceLogger.timedExec((long)1000L, (String)marker, () -> {
            blockExecuted[0] = true;
        });
        Assert.assertTrue((boolean)blockExecuted[0]);
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)marker)));
        blockExecuted[0] = false;
        PerformanceLogger.timedExec((String)marker, () -> {
            blockExecuted[0] = true;
        });
        Assert.assertTrue((boolean)blockExecuted[0]);
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.containsString((String)marker));
    }

    @Test
    public void testTimedProviders() {
        String funName = "testTimedProviders";
        String expectedResult = "42";
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)funName)));
        String actualResult = (String)PerformanceLogger.timedExec(() -> expectedResult);
        Assert.assertThat((Object)expectedResult, (Matcher)Matchers.is((Object)actualResult));
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.containsString((String)funName));
        String marker = funName + ":marker";
        actualResult = (String)PerformanceLogger.timedExec((long)1000L, (String)marker, () -> expectedResult);
        Assert.assertThat((Object)expectedResult, (Matcher)Matchers.is((Object)actualResult));
        Assert.assertThat((Object)UnitTestAppender.logString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)marker)));
        actualResult = (String)PerformanceLogger.timedExec((String)marker, () -> expectedResult);
    }
}

