/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.DefaultPerformanceLogFormatter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultPerformanceLogFormatter {
    @Test
    public void testFormat() {
        TestDefaultPerformanceLogFormatter.testFormat(null, null, 111L, null, "   111ms ", "?");
        TestDefaultPerformanceLogFormatter.testFormat(null, null, 1234567L, null, "1234567ms ", "?");
        TestDefaultPerformanceLogFormatter.testFormat(new StackTraceElement(SomeClass.NAME, "foo", null, -1), null, 111L, null, "   111ms ", "?", "foo");
        TestDefaultPerformanceLogFormatter.testFormat(new StackTraceElement(SomeClass.NAME, "foo", null, -2), null, 111L, "test", "   111ms ", "test", "?", "foo");
        TestDefaultPerformanceLogFormatter.testFormat(new StackTraceElement(SomeClass.NAME, "bar", "From.java", -1), new StackTraceElement(SomeOtherClass.NAME, "to", "To.java", 33), 66L, null, SomeClass.SIMPLE_NAME, SomeOtherClass.SIMPLE_NAME, "to", "33", "66", "?", "bar");
        TestDefaultPerformanceLogFormatter.testFormat(new StackTraceElement(SomeClass.NAME, "method", "Clazz.java", 88), new StackTraceElement(SomeClass.NAME, "method", "Clazz.java", 99), 313L, "***", "88", "99", "   313ms ", SomeClass.SIMPLE_NAME, "method");
        TestDefaultPerformanceLogFormatter.testFormat(new StackTraceElement(SomeClass.NAME, "method", "Clazz.java", 88), new StackTraceElement(SomeClass.NAME, "otherMethod", "Clazz.java", 99), 313L, "***", "88", "99", "   313ms ", SomeClass.SIMPLE_NAME, "method", "otherMethod");
    }

    private static void testFormat(StackTraceElement from, StackTraceElement to, long ms, String msg, String ... lookFor) {
        DefaultPerformanceLogFormatter formatter = new DefaultPerformanceLogFormatter();
        String res = formatter.format(from, to, ms, msg);
        for (String s : lookFor) {
            Assert.assertThat((Object)res, (Matcher)Matchers.containsString((String)s));
        }
    }

    private static class SomeOtherClass {
        static final String NAME = SomeOtherClass.class.getName();
        static final String SIMPLE_NAME = SomeOtherClass.class.getSimpleName();

        private SomeOtherClass() {
        }
    }

    private static class SomeClass {
        static final String NAME = SomeClass.class.getName();
        static final String SIMPLE_NAME = SomeClass.class.getSimpleName();

        private SomeClass() {
        }
    }
}

